//HDRTV GLSL shader
//license: GPL
//original version by SimoneT
// GLSL ruby port by byuu
// HLSL ruby port by mudlord
texture rubyTexture;

sampler s0 = sampler_state { texture = <rubyTexture>; };

float4 BloomPass( in float2 Tex : TEXCOORD0 ) : COLOR0
{
	float4 col = tex2D( s0, Tex );
	float4 intens = smoothstep(0.2,0.8,col) + + normalize(float4(col.rgb, 1.0));
	if(frac(Tex.y * 0.5) > 0.5) intens = col * 0.8;
	return intens;
}

Technique T0
{
    pass p0 { PixelShader = compile ps_2_0 BloomPass(); }
}

